/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.dbutilities.Base64;
import at.tugraz.genome.lda.Lipidomics2DPainter;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.quantification.LipidomicsChromatogram;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.swing.RangeColor;
import at.tugraz.genome.lda.vos.SpectrumPointVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.voutils.GeneralComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

public class Lipidomics2DSpectraChromPainter
extends Lipidomics2DPainter {
    private static final long serialVersionUID = 4970922671009881695L;
    private int pixelsForPeakDescription_ = 5;
    private Hashtable<Integer, String> spectra_;
    private Hashtable<Integer, Vector<Double>> precursors_;
    private Hashtable<Integer, Integer> levels_;
    private List<Integer> spectraSequence_;
    private List<Integer> ms2SpectraSequence_;
    private int spectrumSelected_;
    private static final int DEFAULT_MS_LEVEL = 2;
    private Hashtable<Integer, Vector<RangeColor>> rangeColors_;
    private Vector<Range> timeRanges_;
    private double annotationCutoff_;
    private boolean isShotgun_;

    public Lipidomics2DSpectraChromPainter(LipidomicsAnalyzer analyzer, Hashtable<Integer, String> rtNrSpectrumHash, Hashtable<Integer, Vector<Double>> rtNrPrecursorHash, Hashtable<Integer, Integer> scanNrLevelHash, Hashtable<Integer, Float> retentionTimes, float precRt, float mzStart, float mzStop, int resolutionFactor, float stepSize, ActionListener listener, float start, float stop, boolean raw, Vector<CgProbe> storedProbes, Vector<CgProbe> selectedProbes, int isotopeNumber, int charge, boolean relativeIntensity, double annotationCutoff, boolean isShotgun) {
        super(analyzer, new String[0], retentionTimes, mzStart, mzStop, resolutionFactor, stepSize, listener, 100, start, stop, raw, storedProbes, selectedProbes, isotopeNumber, charge, 1, false);
        this.remove(this.m_txtMz);
        this.m_txtMz = null;
        this.spectra_ = rtNrSpectrumHash;
        this.precursors_ = rtNrPrecursorHash;
        this.levels_ = scanNrLevelHash;
        this.spectraSequence_ = new ArrayList<Integer>(this.spectra_.keySet());
        this.ms2SpectraSequence_ = new ArrayList<Integer>();
        Collections.sort(this.spectraSequence_);
        for (Integer scanNr : this.spectraSequence_) {
            if (scanNrLevelHash.get(scanNr) != 2) continue;
            this.ms2SpectraSequence_.add(scanNr);
        }
        this.spectrumSelected_ = -1;
        float diff = Float.MAX_VALUE;
        boolean containsDefaultLevel = false;
        for (Integer level : this.levels_.values()) {
            if (level != 2) continue;
            containsDefaultLevel = true;
            break;
        }
        for (int i = 0; i != this.spectraSequence_.size(); ++i) {
            float rt;
            int rtNr = this.spectraSequence_.get(i);
            if (containsDefaultLevel && this.levels_.get(rtNr) != 2 || !(Math.abs((rt = ((Float)this.retentionTimes_.get(rtNr)).floatValue()) - precRt) < diff)) continue;
            diff = Math.abs(rt - precRt);
            this.spectrumSelected_ = i;
        }
        this.selectSpectrum(this.spectrumSelected_);
        this.m_minDispTime2d_ = mzStart;
        this.m_maxDispTime2d_ = mzStop;
        this.m_minTime_ = this.m_minDispTime2d_;
        this.m_maxTime_ = this.m_maxDispTime2d_;
        this.timeCorrectionFactor_ = 1.0f;
        this.relativeIntensity_ = relativeIntensity;
        this.rangeColors_ = null;
        this.timeRanges_ = null;
        this.m_2dGain_ = 0.97f;
        this.annotationCutoff_ = annotationCutoff;
        this.isShotgun_ = isShotgun;
    }

    public Lipidomics2DSpectraChromPainter(LipidomicsAnalyzer analyzer, Hashtable<Integer, String> rtNrSpectrumHash, Hashtable<Integer, Vector<Double>> rtNrPrecursorHash, Hashtable<Integer, Integer> scanNrLevelHash, Hashtable<Integer, Float> retentionTimes, float precRt, float mzStart, float mzStop, int resolutionFactor, float stepSize, ActionListener listener, float start, float stop, boolean raw, Vector<CgProbe> storedProbes, Vector<CgProbe> selectedProbes, int isotopeNumber, int charge, boolean relativeIntensity, LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors, double annotationCutoff, boolean isShotgun) {
        this(analyzer, rtNrSpectrumHash, rtNrPrecursorHash, scanNrLevelHash, retentionTimes, precRt, mzStart, mzStop, resolutionFactor, stepSize, listener, start, stop, raw, storedProbes, selectedProbes, isotopeNumber, charge, relativeIntensity, annotationCutoff, isShotgun);
        this.setRangeColors(param, rangeColors);
    }

    private void setRangeColors(LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors) {
        if (param instanceof LipidomicsMSnSet) {
            this.rangeColors_ = rangeColors;
            this.timeRanges_ = new Vector();
            if (this.isShotgun_) {
                this.timeRanges_.add(new Range(0.0f, Float.MAX_VALUE));
            } else {
                for (CgProbe probe : param.getIsotopicProbes().get(0)) {
                    this.timeRanges_.add(new Range(probe.LowerValley, probe.UpperValley));
                }
            }
        }
    }

    public void setParam(LipidParameterSet param) {
        if (param instanceof LipidomicsMSnSet) {
            this.timeRanges_ = new Vector();
            if (this.isShotgun_) {
                this.timeRanges_.add(new Range(0.0f, Float.MAX_VALUE));
            } else {
                for (CgProbe probe : param.getIsotopicProbes().get(0)) {
                    this.timeRanges_.add(new Range(probe.LowerValley, probe.UpperValley));
                }
            }
        }
    }

    @Override
    protected void setInputLocations() {
        this.m_txtTime.setBounds(this.getWidth() - 100, 5, 95, 20);
        this.m_txtIntensity.setBounds(this.getWidth() - 100, 27, 95, 20);
        this.m_plusGain.setBounds(this.getWidth() - 65, this.m_txtIntensity.getY() + 23, 60, 24);
        this.m_minusGain.setBounds(this.getWidth() - 65, this.m_plusGain.getY() + 25, 60, 24);
        this.m_plusShift.setBounds(this.getWidth() - 35, this.m_minusGain.getY() + 25, 30, 24);
        this.m_minusShift.setBounds(this.getWidth() - 65, this.m_minusGain.getY() + 25, 30, 24);
    }

    private LipidomicsChromatogram mergeSpectra(Collection<Integer> scanNumbers) {
        Hashtable<String, SpectrumPointVO> intensityPoints = new Hashtable<String, SpectrumPointVO>();
        for (Integer scanNr : scanNumbers) {
            String spectrum = this.spectra_.get(scanNr);
            FloatBuffer buffer = ByteBuffer.wrap(Base64.decode(spectrum)).asFloatBuffer();
            int iItems = buffer.limit();
            float mzValue = 0.0f;
            for (int iItem = 0; iItem < iItems; ++iItem) {
                if (iItem % 2 == 0) {
                    mzValue = buffer.get();
                    continue;
                }
                float intensity = buffer.get();
                String mzOriginal = String.valueOf(mzValue);
                SpectrumPointVO vo = null;
                vo = intensityPoints.containsKey(mzOriginal) ? (SpectrumPointVO)intensityPoints.get(mzOriginal) : new SpectrumPointVO(mzOriginal, mzValue);
                vo.addIntensity(intensity);
                if (vo.getIntensity() > this.maxIntensity_) {
                    this.maxIntensity_ = vo.getIntensity();
                }
                intensityPoints.put(mzOriginal, vo);
            }
        }
        ArrayList vos = new ArrayList(intensityPoints.values());
        Collections.sort(vos, new GeneralComparator("at.tugraz.genome.lda.vos.SpectrumPointVO", "getMz", "java.lang.Float"));
        LipidomicsChromatogram spectrum = new LipidomicsChromatogram(vos.size());
        for (int i = 0; i != vos.size(); ++i) {
            SpectrumPointVO vo = (SpectrumPointVO)vos.get(i);
            spectrum.Value[i][0] = vo.getMz();
            spectrum.Value[i][1] = vo.getIntensity();
        }
        return spectrum;
    }

    @Override
    protected void draw2DDiagram(Graphics gx, float start, float stop, boolean raw) {
        gx.setColor(Color.WHITE);
        gx.fillRect(0, 0, this.getWidth(), this.getHeight());
        gx.setColor(Color.BLACK);
        this.raw_ = raw;
        int x0 = this.leftMargin_2d();
        int y0 = this.getHeight() - this.bottomMargin_2d();
        int w0 = this.diagramWidth_2d();
        int h0 = this.diagramHeight_2d();
        Vector<RangeColor> rColors = null;
        if (this.isSpectrumInIdentfiedRegion()) {
            int msLevel = 2;
            if (this.spectrumSelected_ > -1) {
                msLevel = this.levels_.get(this.spectraSequence_.get(this.spectrumSelected_));
            }
            rColors = this.rangeColors_.get(msLevel);
        }
        Lipidomics2DSpectraChromPainter.draw2DDiagram(gx, this.cr_, x0, y0, w0, h0, this.m_minDispTime2d_, this.m_maxDispTime2d_, this.maxIntensity_, this.m_2dGain_, 100, 1.0f, this.raw_, true, this.relativeIntensity_, true, null, rColors, false);
        this.drawSpectrumLegend(gx, this.cr_, 0.5f, x0, y0, w0, h0, this.m_minDispTime2d_, this.m_maxDispTime2d_, this.maxIntensity_, this.m_2dGain_, raw, this.relativeIntensity_, rColors);
    }

    private boolean isSpectrumInIdentfiedRegion() {
        if (this.spectrumSelected_ < 0) {
            return true;
        }
        if (this.timeRanges_ != null && this.timeRanges_.size() > 0) {
            float rt = ((Float)this.retentionTimes_.get(this.spectraSequence_.get(this.spectrumSelected_))).floatValue();
            for (Range range : this.timeRanges_) {
                if (!range.insideRange(rt)) continue;
                return true;
            }
        }
        return false;
    }

    protected void drawSpectrumLegend(Graphics gx, LipidomicsChromatogram cr, float mzTolerance, int x0, int y0, int w0, int h0, float mzStart, float mzStop, float maxIntensity, float m_2dGain, boolean raw, boolean relativeValue, Vector<RangeColor> rColors) {
        Vector<Integer> groupedInts = new Vector<Integer>();
        LinkedHashMap<Integer, Float> possIntsMz = new LinkedHashMap<Integer, Float>();
        LinkedHashMap<Integer, Float> possIntsInt = new LinkedHashMap<Integer, Float>();
        Hashtable<String, Float> highestInts = new Hashtable<String, Float>();
        Hashtable<String, Integer> highestIntPos = new Hashtable<String, Integer>();
        for (int i = 0; i < cr.Value.length; ++i) {
            Object color;
            float mz = cr.Value[i][0];
            if (mz < mzStart || mz > mzStop) continue;
            if (rColors != null && (color = Lipidomics2DSpectraChromPainter.getColorAccordingToXPos(mz, rColors)) != null) {
                float highInt = 0.0f;
                if (highestInts.containsKey(((RangeColor)color).getName())) {
                    highInt = ((Float)highestInts.get(((RangeColor)color).getName())).floatValue();
                }
                float value = 0.0f;
                value = raw ? cr.Value[i][1] : cr.Value[i][2];
                if (value > highInt) {
                    highInt = value;
                    highestInts.put(((RangeColor)color).getName(), Float.valueOf(highInt));
                    highestIntPos.put(((RangeColor)color).getName(), i);
                }
            }
            color = possIntsMz.keySet().iterator();
            while (color.hasNext()) {
                Integer pos = (Integer)color.next();
                if (!(((Float)possIntsMz.get(pos)).floatValue() + mzTolerance < mz)) continue;
                groupedInts.add(pos);
                possIntsMz.remove(pos);
                possIntsInt.remove(pos);
            }
            float value = 0.0f;
            value = raw ? cr.Value[i][1] : cr.Value[i][2];
            if (!(value > 0.0f)) continue;
            boolean foundHigherOne = false;
            for (Integer pos : possIntsMz.keySet()) {
                float otherValue = ((Float)possIntsInt.get(pos)).floatValue();
                if (otherValue > value) {
                    foundHigherOne = true;
                    continue;
                }
                possIntsMz.remove(pos);
                possIntsInt.remove(pos);
            }
            if (foundHigherOne) continue;
            possIntsMz.put(i, Float.valueOf(mz));
            possIntsInt.put(i, Float.valueOf(value));
        }
        for (Integer pos : possIntsMz.keySet()) {
            groupedInts.add(pos);
        }
        gx.setFont(new Font("SansSerif", 0, 10));
        FontMetrics fm = gx.getFontMetrics();
        for (Integer pos : groupedInts) {
            int[] coords = Lipidomics2DSpectraChromPainter.getCoordinatesInDiagram(cr.Value, pos, x0, y0, w0, h0, mzStart, mzStop, maxIntensity, m_2dGain, raw, relativeValue, false);
            double rel = (double)(cr.Value[pos][1] / maxIntensity) * 100.0;
            boolean isAnnotatedPeak = false;
            RangeColor color = null;
            if (rColors != null) {
                for (RangeColor rc : rColors) {
                    float highestRt;
                    float rt;
                    if (!highestIntPos.containsKey(rc.getName()) || !((rt = cr.Value[pos][0]) - mzTolerance < (highestRt = cr.Value[(Integer)highestIntPos.get(rc.getName())][0])) || !(highestRt < rt + mzTolerance)) continue;
                    isAnnotatedPeak = true;
                    color = rc;
                }
            }
            if (coords[0] <= x0 || coords[0] >= x0 + w0 || coords[1] <= y0 - h0 || coords[1] >= y0 - h0 / 500 || !(rel >= this.annotationCutoff_) && !isAnnotatedPeak) continue;
            String mzValue = String.valueOf(Calculator.roundFloat(cr.Value[pos][0], 3));
            int x = coords[0] - fm.stringWidth(mzValue) / 2;
            int y = coords[1] - this.pixelsForPeakDescription_ - fm.getDescent();
            if (isAnnotatedPeak) {
                gx.setColor(color.getColor());
            }
            gx.drawString(mzValue, x, y);
            if (!isAnnotatedPeak) continue;
            gx.setColor(Color.BLACK);
        }
        if (rColors != null) {
            for (RangeColor rc : rColors) {
                int[] coords;
                if (!highestIntPos.containsKey(rc.getName()) || (coords = Lipidomics2DSpectraChromPainter.getCoordinatesInDiagram(cr.Value, (Integer)highestIntPos.get(rc.getName()), x0, y0, w0, h0, mzStart, mzStop, maxIntensity, m_2dGain, raw, relativeValue, false))[0] <= x0 || coords[0] >= x0 + w0 || coords[1] <= y0 - h0 || coords[1] >= y0 - h0 / 500) continue;
                int x = coords[0] - fm.stringWidth(rc.getName()) / 2;
                int y = coords[1] - fm.getHeight() - this.pixelsForPeakDescription_ - fm.getDescent();
                gx.setColor(rc.getColor());
                gx.drawString(rc.getName(), x, y);
            }
            gx.setColor(Color.BLACK);
        }
    }

    @Override
    public void setShownRetentionTime(float newVal) {
        this.m_txtTime.setText("m/z = " + Calculator.roundFloat(newVal, 4));
    }

    @Override
    public int checkPopupClick(int x, int y) {
        return 0;
    }

    @Override
    public void nextSpectrum(LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors) {
        this.setRangeColors(param, rangeColors);
        this.selectSpectrum(this.spectrumSelected_ + 1);
    }

    @Override
    public void nextSpectrum() {
        this.selectSpectrum(this.spectrumSelected_ + 1);
    }

    @Override
    public void previousSpectrum(LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors) {
        this.setRangeColors(param, rangeColors);
        this.previousSpectrum();
    }

    @Override
    public void refresh(LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors) {
        this.setRangeColors(param, rangeColors);
        this.selectSpectrum(this.spectrumSelected_);
    }

    @Override
    public void clearRangeColors() {
        this.rangeColors_ = new Hashtable();
        this.timeRanges_ = new Vector();
        this.selectSpectrum(this.spectrumSelected_);
    }

    @Override
    public void previousSpectrum() {
        this.selectSpectrum(this.spectrumSelected_ - 1);
    }

    private void selectSpectrum(int spectrumNr) {
        this.spectrumSelected_ = spectrumNr;
        if (this.spectrumSelected_ >= this.spectra_.size()) {
            this.spectrumSelected_ = -1;
        }
        if (this.spectrumSelected_ < -1) {
            this.spectrumSelected_ = this.spectra_.size() - 1;
        }
        this.maxIntensity_ = 0.0f;
        if (this.spectrumSelected_ == -1) {
            this.cr_ = this.mergeSpectra(this.ms2SpectraSequence_);
        } else {
            Vector<Integer> scanNumbers = new Vector<Integer>();
            int scanNr = this.spectraSequence_.get(this.spectrumSelected_);
            scanNumbers.add(scanNr);
            this.cr_ = this.mergeSpectra(scanNumbers);
        }
        this.repaint();
    }

    @Override
    public String getSpectSelectedText() {
        if (this.spectrumSelected_ == -1) {
            return "Sum(" + String.valueOf(this.ms2SpectraSequence_.size()) + ")";
        }
        return String.valueOf(this.spectrumSelected_ + 1) + "/" + this.spectra_.size();
    }

    @Override
    public String getRtSelectedText() {
        if (this.spectrumSelected_ == -1) {
            return "";
        }
        return String.valueOf(Calculator.roundFloat(((Float)this.retentionTimes_.get(this.spectraSequence_.get(this.spectrumSelected_))).floatValue() / 60.0f, 2));
    }

    @Override
    public Vector<Double> getPrecursorMassSelected() {
        if (this.spectrumSelected_ == -1) {
            return new Vector<Double>();
        }
        return this.precursors_.get(this.spectraSequence_.get(this.spectrumSelected_));
    }

    @Override
    public String getMsLevelSelected() {
        if (this.spectrumSelected_ == -1) {
            return "";
        }
        return String.valueOf(this.levels_.get(this.spectraSequence_.get(this.spectrumSelected_)));
    }

    @Override
    public float[] getRTRange() {
        int stopSpectrumNr;
        int startSpectrumNr;
        if (this.spectrumSelected_ == -1) {
            return new float[]{0.0f, 0.0f};
        }
        float[] range = new float[2];
        for (startSpectrumNr = this.spectrumSelected_; startSpectrumNr != 0 && this.levels_.get(this.spectraSequence_.get(startSpectrumNr)) != 2; --startSpectrumNr) {
        }
        if (startSpectrumNr < 1) {
            range[0] = ((Float)this.retentionTimes_.get(this.spectraSequence_.get(0))).floatValue();
        } else {
            --startSpectrumNr;
            while (startSpectrumNr != 0 && this.levels_.get(this.spectraSequence_.get(startSpectrumNr)) != 2) {
                --startSpectrumNr;
            }
            range[0] = ((Float)this.retentionTimes_.get(this.spectraSequence_.get(startSpectrumNr))).floatValue();
        }
        for (stopSpectrumNr = this.spectrumSelected_; stopSpectrumNr != this.spectraSequence_.size() - 1 && this.levels_.get(this.spectraSequence_.get(stopSpectrumNr)) != 2; ++stopSpectrumNr) {
        }
        if (stopSpectrumNr >= this.spectraSequence_.size() - 1) {
            range[1] = ((Float)this.retentionTimes_.get(this.spectraSequence_.get(this.spectraSequence_.size() - 1))).floatValue();
        } else {
            ++stopSpectrumNr;
            while (stopSpectrumNr != this.spectraSequence_.size() - 1 && this.levels_.get(this.spectraSequence_.get(stopSpectrumNr)) != 2) {
                ++stopSpectrumNr;
            }
            range[1] = ((Float)this.retentionTimes_.get(this.spectraSequence_.get(stopSpectrumNr))).floatValue();
        }
        return range;
    }

    @Override
    public int getSpectrumSelected() {
        return this.spectrumSelected_;
    }

    @Override
    public int getMs2LevelSpectrumSelected() {
        return this.getMs2LevelSpectrumSelected(this.spectrumSelected_);
    }

    @Override
    public int getMs2LevelSpectrumSelected(int specNr) {
        int ms2Number = -1;
        int nr = specNr;
        if (nr >= this.spectra_.size()) {
            nr = -1;
        }
        if (nr < -1) {
            nr = this.spectra_.size() - 1;
        }
        for (int i = 0; i != nr + 1; ++i) {
            if (this.levels_.get(this.spectraSequence_.get(i)) != 2) continue;
            ++ms2Number;
        }
        return ms2Number;
    }

    @Override
    public void setAnnotationThreshold(double cutoff) {
        this.annotationCutoff_ = cutoff;
        this.selectSpectrum(this.spectrumSelected_);
    }

    public void writeMgf(File file, String rawFileName) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file.getAbsolutePath()));
        stream.write("BEGIN IONS\n".getBytes());
        stream.write(("TITLE=" + rawFileName + "\n").getBytes());
        String rtString = "RTINSECONDS=";
        String pepMassString = "PEPMASS=";
        if (this.spectrumSelected_ >= 0) {
            rtString = rtString + Calculator.roundFloat(((Float)this.retentionTimes_.get(this.spectraSequence_.get(this.spectrumSelected_))).floatValue(), 4) + "\n";
            pepMassString = pepMassString + this.precursors_.get(this.spectraSequence_.get(this.spectrumSelected_)) + "\n";
        } else {
            rtString = rtString + "\n";
            pepMassString = pepMassString + "\n";
        }
        stream.write(rtString.getBytes());
        stream.write(pepMassString.getBytes());
        for (int i = 0; i != this.cr_.Value.length; ++i) {
            if (!(this.cr_.Value[i][1] > 0.0f)) continue;
            stream.write((this.cr_.Value[i][0] + " " + this.cr_.Value[i][1] + "\n").getBytes());
        }
        stream.write("END IONS\n".getBytes());
        stream.close();
    }
}

