/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.dbutilities.Base64;
import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.QuantificationException;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.quantification.LipidomicsChromatogram;
import at.tugraz.genome.lda.quantification.LipidomicsDefines;
import at.tugraz.genome.lda.swing.AreaSettingDialog;
import at.tugraz.genome.lda.swing.RangeColor;
import at.tugraz.genome.lda.vos.AreaSettingVO;
import at.tugraz.genome.maspectras.quantification.CgAreaStatus;
import at.tugraz.genome.maspectras.quantification.CgChromatogram;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.Probe3D;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;

public class Lipidomics2DPainter
extends Panel
implements ActionListener,
MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 6648556947005652657L;
    private String[] dataStrings_;
    protected Hashtable<Integer, Float> retentionTimes_;
    protected Hashtable<Integer, Float> retentionTimesOriginal_;
    private float mzStart_;
    private float mzStop_;
    private int resolutionFactor_;
    private float stepSize_;
    private ActionListener superiorListener_;
    protected int displayTime_;
    protected boolean raw_;
    private int currentStart_;
    private int currentStop_;
    protected float maxIntensity_;
    protected float timeCorrectionFactor_;
    private float chromMzStart_;
    private float chromMzStop_;
    Vector<CgProbe> storedProbes_;
    Vector<CgProbe> selectedProbes_;
    Vector<CgProbe> removedStoredProbes_;
    private Cursor m_crosshair;
    protected TextField m_txtMz;
    protected TextField m_txtTime;
    protected TextField m_txtIntensity;
    protected Button m_plusGain;
    protected Button m_minusGain;
    protected Button m_plusShift;
    protected Button m_minusShift;
    private PopupMenu m_popup;
    private MenuItem m_addUserProbe1;
    private MenuItem m_addUserProbe2;
    private MenuItem m_addUserProbe3;
    private MenuItem m_addUserProbe4;
    private MenuItem m_enterUserProbe;
    private MenuItem m_deleteUserProbe;
    public int lastPopupX = 0;
    public int lastPopupY = 0;
    protected float m_2dGain_;
    protected float m_minDispTime2d_;
    protected float m_maxDispTime2d_;
    protected float m_minTime_;
    protected float m_maxTime_;
    private int isotopeNumber_;
    protected LipidomicsChromatogram cr_;
    private LipidomicsAnalyzer analyzer_;
    private CgProbe probeToAdjust_;
    private boolean isProbeToAdjustSystemProbe_;
    private AreaSettingDialog areaSettings_;
    private int charge_;
    private int msLevel_;
    public static final int DISPLAY_TIME_MZ = 100;
    protected boolean relativeIntensity_;
    private static final float defaultIntensityRangeMultiplicator_ = 1.05f;
    private int leftMouseClickLocationX_;
    private int leftMouseClickLocationY_;
    private Float ms2Position_;
    private boolean doSparseCorrection_ = false;
    private boolean shotgun_ = false;
    private static boolean thickChrom_ = false;

    public Lipidomics2DPainter(LipidomicsAnalyzer analyzer, String[] dataStrings, Hashtable<Integer, Float> retentionTimes, float mzStart, float mzStop, int resolutionFactor, float stepSize, ActionListener listener, int displayTime, float start, float stop, boolean raw, Vector<CgProbe> storedProbes, Vector<CgProbe> selectedProbes, int isotopeNumber, int charge, int msLevel, boolean shotgun) {
        this(analyzer, dataStrings, retentionTimes, null, mzStart, mzStop, resolutionFactor, stepSize, listener, displayTime, start, stop, raw, storedProbes, selectedProbes, isotopeNumber, charge, msLevel, shotgun);
    }

    public Lipidomics2DPainter(LipidomicsAnalyzer analyzer, String[] dataStrings, Hashtable<Integer, Float> retentionTimes, Hashtable<Integer, Float> rTimesInterpolated, float mzStart, float mzStop, int resolutionFactor, float stepSize, ActionListener listener, int displayTime, float start, float stop, boolean raw, Vector<CgProbe> storedProbes, Vector<CgProbe> selectedProbes, int isotopeNumber, int charge, int msLevel, boolean shotgun) {
        this.analyzer_ = analyzer;
        this.dataStrings_ = dataStrings;
        this.retentionTimes_ = retentionTimes;
        if (LipidomicsConstants.isSparseData() && rTimesInterpolated != null) {
            this.retentionTimes_ = rTimesInterpolated;
            this.retentionTimesOriginal_ = retentionTimes;
            this.doSparseCorrection_ = true;
        }
        this.mzStart_ = mzStart;
        this.mzStop_ = mzStop;
        this.resolutionFactor_ = resolutionFactor;
        this.stepSize_ = stepSize;
        this.superiorListener_ = listener;
        if (this.superiorListener_ == null) {
            this.superiorListener_ = this;
        }
        this.displayTime_ = displayTime;
        this.timeCorrectionFactor_ = 1.0f;
        if (this.displayTime_ == 1) {
            this.timeCorrectionFactor_ = 60.0f;
        }
        this.maxIntensity_ = 0.0f;
        this.m_2dGain_ = 1.0f;
        this.currentStart_ = Math.round(start * (float)this.resolutionFactor_);
        this.currentStop_ = Math.round(stop * (float)this.resolutionFactor_);
        this.m_crosshair = new Cursor(1);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.storedProbes_ = storedProbes;
        this.selectedProbes_ = selectedProbes;
        this.removedStoredProbes_ = new Vector();
        this.isotopeNumber_ = isotopeNumber;
        this.charge_ = charge;
        this.msLevel_ = msLevel;
        this.relativeIntensity_ = false;
        this.leftMouseClickLocationX_ = -1;
        this.leftMouseClickLocationY_ = -1;
        this.raw_ = raw;
        this.shotgun_ = shotgun;
        this.initialize();
    }

    public void initialize() {
        this.areaSettings_ = new AreaSettingDialog(new JFrame(), "Probe borders", "Enter the borders of the peak", this);
        this.m_txtMz = new TextField();
        this.m_txtMz.setBackground(Color.WHITE);
        this.m_txtMz.setEnabled(false);
        this.m_txtMz.setForeground(Color.BLACK);
        this.m_txtMz.setVisible(true);
        this.add(this.m_txtMz);
        this.m_txtTime = new TextField();
        this.m_txtTime.setBackground(Color.WHITE);
        this.m_txtTime.setForeground(Color.BLACK);
        this.m_txtTime.setEnabled(false);
        this.m_txtTime.setVisible(true);
        this.add(this.m_txtTime);
        this.m_txtIntensity = new TextField();
        this.m_txtIntensity.setBackground(Color.WHITE);
        this.m_txtIntensity.setForeground(Color.BLACK);
        this.m_txtIntensity.setEnabled(false);
        this.m_txtIntensity.setVisible(true);
        this.add(this.m_txtIntensity);
        this.m_plusGain = new Button();
        this.m_plusGain.setLabel("+ Gain");
        this.m_plusGain.setActionCommand("Plus2dGain");
        this.m_plusGain.addActionListener(this);
        this.add(this.m_plusGain);
        this.m_minusGain = new Button();
        this.m_minusGain.setLabel("- Gain");
        this.m_minusGain.setActionCommand("Minus2dGain");
        this.m_minusGain.addActionListener(this);
        this.add(this.m_minusGain);
        this.m_plusShift = new Button();
        this.m_plusShift.setLabel(">>");
        this.m_plusShift.setActionCommand("Plus2dShift");
        this.m_plusShift.addActionListener(this);
        this.add(this.m_plusShift);
        this.m_minusShift = new Button();
        this.m_minusShift.setLabel("<<");
        this.m_minusShift.setActionCommand("Minus2dShift");
        this.m_minusShift.addActionListener(this);
        this.add(this.m_minusShift);
        this.m_popup = new PopupMenu("Peak selection");
        if (!this.shotgun_) {
            this.m_addUserProbe4 = new MenuItem("Determine Area (3D)");
            this.m_addUserProbe4.addActionListener(this.superiorListener_);
            this.m_popup.add(this.m_addUserProbe4);
        }
        this.m_addUserProbe1 = new MenuItem("Determine Area");
        this.m_addUserProbe1.addActionListener(this.superiorListener_);
        this.m_popup.add(this.m_addUserProbe1);
        if (!this.shotgun_) {
            this.m_addUserProbe2 = new MenuItem("Determine Area (Col)");
            this.m_addUserProbe2.addActionListener(this.superiorListener_);
            this.m_popup.add(this.m_addUserProbe2);
            this.m_addUserProbe3 = new MenuItem("Determine Area (Greedy)");
            this.m_addUserProbe3.addActionListener(this.superiorListener_);
            this.m_popup.add(this.m_addUserProbe3);
            this.m_enterUserProbe = new MenuItem("Enter probe borders");
            this.m_enterUserProbe.addActionListener(this);
            this.m_popup.add(this.m_enterUserProbe);
        }
        this.m_popup.addSeparator();
        this.m_deleteUserProbe = new MenuItem("Delete Area");
        this.m_deleteUserProbe.addActionListener(this.superiorListener_);
        this.m_popup.add(this.m_deleteUserProbe);
        this.add(this.m_popup);
        this.setInputLocations();
    }

    protected void setInputLocations() {
        this.m_txtMz.setBounds(this.getWidth() - 100, 5, 95, 20);
        this.m_txtTime.setBounds(this.getWidth() - 100, 27, 95, 20);
        this.m_txtIntensity.setBounds(this.getWidth() - 100, 49, 95, 20);
        this.m_plusGain.setBounds(this.getWidth() - 65, this.m_txtIntensity.getY() + 23, 60, 24);
        this.m_minusGain.setBounds(this.getWidth() - 65, this.m_plusGain.getY() + 25, 60, 24);
        this.m_plusShift.setBounds(this.getWidth() - 35, this.m_minusGain.getY() + 25, 30, 24);
        this.m_minusShift.setBounds(this.getWidth() - 65, this.m_minusGain.getY() + 25, 30, 24);
    }

    public void preChromatogramExtraxtion(float start, float stop) {
        int startAsInt = Math.round(start * (float)this.resolutionFactor_);
        int stopAsInt = Math.round(stop * (float)this.resolutionFactor_);
        boolean setMinMaxTimes = false;
        if (this.cr_ == null) {
            setMinMaxTimes = true;
        }
        if (this.cr_ == null || startAsInt != this.currentStart_ || stopAsInt != this.currentStop_) {
            this.cr_ = this.extractChromatogram(start, stop);
            this.m_minTime_ = 0.0f;
            this.m_maxTime_ = this.cr_.Value[this.cr_.Value.length - 1][0];
            if (setMinMaxTimes) {
                this.m_minDispTime2d_ = this.m_minTime_;
            }
            this.m_maxDispTime2d_ = this.m_maxTime_;
        }
    }

    public void draw2DDiagram(float start, float stop, boolean raw) {
        this.draw2DDiagram(this.getGraphics(), start, stop, raw);
    }

    public void draw2DDiagram(Graphics g) {
        this.draw2DDiagram(g, Float.valueOf(String.valueOf(this.currentStart_)).floatValue() / (float)this.resolutionFactor_, Float.valueOf(String.valueOf(this.currentStop_)).floatValue() / (float)this.resolutionFactor_, this.raw_);
    }

    protected void draw2DDiagram(Graphics g, float start, float stop, boolean raw) {
        this.chromMzStart_ = start;
        this.chromMzStop_ = stop;
        this.raw_ = raw;
        int x0 = this.leftMargin_2d();
        int y0 = this.getHeight() - this.bottomMargin_2d();
        int w0 = this.diagramWidth_2d();
        int h0 = this.diagramHeight_2d();
        int startAsInt = Math.round(start * (float)this.resolutionFactor_);
        int stopAsInt = Math.round(stop * (float)this.resolutionFactor_);
        boolean setMinMaxTimes = false;
        if (this.cr_ == null) {
            setMinMaxTimes = true;
        }
        if (this.cr_ == null || startAsInt != this.currentStart_ || stopAsInt != this.currentStop_) {
            this.cr_ = this.extractChromatogram(start, stop);
            this.m_minTime_ = 0.0f;
            this.m_maxTime_ = this.cr_.Value[this.cr_.Value.length - 1][0];
            if (setMinMaxTimes) {
                this.m_minDispTime2d_ = this.m_minTime_;
            }
            this.m_maxDispTime2d_ = this.m_maxTime_;
        }
        Vector<CgProbe> paintableProbes = new Vector<CgProbe>();
        for (int i = 0; i != this.storedProbes_.size(); ++i) {
            CgProbe aProbe = this.storedProbes_.get(i);
            boolean removed = false;
            for (int j = 0; j != this.removedStoredProbes_.size(); ++j) {
                if (!this.sameCgProbe(this.removedStoredProbes_.get(j), aProbe)) continue;
                removed = true;
            }
            if (removed) continue;
            paintableProbes.add(aProbe);
        }
        this.paint2dAreas(paintableProbes, Color.RED);
        this.paint2dAreas(this.selectedProbes_, Color.GREEN);
        Lipidomics2DPainter.draw2DDiagram(g, this.cr_, x0, y0, w0, h0, this.m_minDispTime2d_, this.m_maxDispTime2d_, this.maxIntensity_, this.m_2dGain_, this.displayTime_, this.timeCorrectionFactor_, this.raw_, true, this.relativeIntensity_, false, this.ms2Position_, false);
        this.currentStart_ = startAsInt;
        this.currentStop_ = stopAsInt;
        this.m_txtMz.setText("mz=" + Calculator.roundFloat((stop + start) / 2.0f, 3) + "D");
    }

    public static void draw2DDiagram(Graphics gx, CgChromatogram cr, Vector<CgProbe> probes, int xIn, int yIn, int wIn, int hIn, int displayTime, float zoomFactor) {
        float maxIntensity = 0.0f;
        for (int scanNumber = 0; scanNumber != cr.Value.length; ++scanNumber) {
            if (!(cr.Value[scanNumber][1] > maxIntensity)) continue;
            maxIntensity = cr.Value[scanNumber][1];
        }
        float timeCorrectionFactor = 1.0f;
        if (displayTime == 1) {
            timeCorrectionFactor = 60.0f;
        }
        int x0 = xIn + 4;
        int y0 = yIn - 7;
        int w0 = wIn - 15;
        int h0 = hIn - 8;
        Lipidomics2DPainter.paint2dAreas(gx, cr, probes, Color.RED, 0, x0, y0, w0, h0, 0.0f, cr.Value[cr.Value.length - 1][0], maxIntensity, zoomFactor, false, false);
        Lipidomics2DPainter.draw2DDiagram(gx, cr, x0, y0, w0, h0, 0.0f, cr.Value[cr.Value.length - 1][0], maxIntensity, zoomFactor, displayTime, timeCorrectionFactor, false, false, false, false, null, true);
    }

    protected static void draw2DDiagram(Graphics gx, CgChromatogram cr, int x0, int y0, int w0, int h0, float m_minDispTime2d, float m_maxDispTime2d, float maxIntensity, float m_2dGain, int displayTime, float timeCorrectionFactor, boolean raw, boolean drawLegend, boolean relativeValue, boolean barChart, Float ms2Position, boolean stopAtH0) {
        Lipidomics2DPainter.draw2DDiagram(gx, cr, x0, y0, w0, h0, m_minDispTime2d, m_maxDispTime2d, maxIntensity, m_2dGain, displayTime, timeCorrectionFactor, raw, drawLegend, relativeValue, barChart, ms2Position, null, stopAtH0);
    }

    protected static void draw2DDiagram(Graphics gx, CgChromatogram cr, int x0, int y0, int w0, int h0, float m_minDispTime2d, float m_maxDispTime2d, float maxIntensity, float m_2dGain, int displayTime, float timeCorrectionFactor, boolean raw, boolean drawLegend, boolean relativeValue, boolean barChart, Float ms2Position, Vector<RangeColor> rangeColors, boolean stopAtH0) {
        int sw;
        String s;
        if (thickChrom_) {
            x0 += 250;
            y0 -= 75;
            w0 = (int)((double)w0 * 0.6);
            h0 = (int)((double)h0 * 0.8);
        }
        int x = 0;
        int y = 0;
        float maxInt = Lipidomics2DPainter.getMaxInt(maxIntensity, relativeValue);
        Lipidomics2DPainter.drawDiagramItself(gx, cr, x0, y0, w0, h0, m_minDispTime2d, m_maxDispTime2d, maxIntensity, m_2dGain, raw, relativeValue, barChart, rangeColors, stopAtH0);
        gx.setColor(Color.BLACK);
        float t = 0.0f;
        int fontSize = 10;
        if (thickChrom_) {
            fontSize = 38;
        }
        gx.setFont(new Font("SansSerif", 0, fontSize));
        FontMetrics fm = gx.getFontMetrics();
        int arrowHeight = 6;
        int arrowWidth = 2;
        if (thickChrom_) {
            arrowHeight = 18;
            arrowWidth = 8;
        }
        int lineEndX = x0 + w0 + 3;
        gx.drawLine(x0, y0, lineEndX, y0);
        gx.drawLine(lineEndX, y0 - arrowWidth, lineEndX, y0 + arrowWidth);
        gx.drawLine(lineEndX, y0 - arrowWidth, lineEndX + arrowHeight, y0);
        gx.drawLine(lineEndX, y0 + arrowWidth, lineEndX + arrowHeight, y0);
        int lineEndY = y0 - h0 + 5;
        gx.drawLine(x0, y0, x0, lineEndY);
        gx.drawLine(x0 - arrowWidth, lineEndY, x0 + arrowWidth, lineEndY);
        gx.drawLine(x0 - arrowWidth, lineEndY, x0, lineEndY - arrowHeight);
        gx.drawLine(x0 + arrowWidth, lineEndY, x0, lineEndY - arrowHeight);
        float dt = 100.0f;
        t = (m_maxDispTime2d - m_minDispTime2d) / 10.0f;
        dt = t < 1.0f ? 1.0f : (t < 10.0f ? 10.0f : (t < 20.0f ? 20.0f : (t < 50.0f ? 50.0f : (t < 100.0f ? 100.0f : (t < 200.0f ? 200.0f : (t < 500.0f ? 500.0f : (t < 1000.0f ? 1000.0f : (t < 2000.0f ? 2000.0f : (t < 5000.0f ? 5000.0f : (t < 10000.0f ? 10000.0f : (t < 20000.0f ? 20000.0f : ((t /= timeCorrectionFactor) < 50000.0f ? 50000.0f : 100000.0f))))))))))));
        String timeUnit = "Time / s";
        if (displayTime == 1) {
            timeUnit = "Time / min";
        } else if (displayTime == 100) {
            timeUnit = "m/z";
        }
        int j = fm.stringWidth(timeUnit);
        int i = (int)(m_minDispTime2d / timeCorrectionFactor / dt);
        t = i > 0 ? (float)(i - 1) * dt : 0.0f;
        while (t * timeCorrectionFactor < m_maxDispTime2d) {
            if (t * timeCorrectionFactor >= m_minDispTime2d) {
                x = x0 + (int)((float)w0 * (t * timeCorrectionFactor - m_minDispTime2d) / (m_maxDispTime2d - m_minDispTime2d));
                y = y0;
                int tickLen = 3;
                if (thickChrom_) {
                    tickLen = 12;
                }
                gx.drawLine(x, y, x, y + tickLen);
                s = Integer.toString((int)t);
                sw = fm.stringWidth(s);
                if (x + sw / 2 + 10 < x0 + w0 - j) {
                    int posX = x - sw / 2;
                    int posY = y + 12;
                    if (thickChrom_) {
                        posY = y + 45;
                    }
                    if (drawLegend) {
                        gx.drawString(s, posX, posY);
                    }
                }
            }
            t += dt;
        }
        int xLegendPosX = x0 + w0 - j + 9;
        int xLegendPosY = y + 12;
        if (thickChrom_) {
            xLegendPosY = y + 45;
        }
        if (drawLegend) {
            gx.drawString(timeUnit, xLegendPosX, xLegendPosY);
        }
        double in = 0.0;
        double din = 0.0;
        in = maxInt / m_2dGain / 5.0f;
        din = in < (double)0.1f ? (double)0.1f : (in < 0.25 ? 0.25 : (in < 0.5 ? 0.5 : (in < 1.0 ? 1.0 : (in < 2.5 ? 2.5 : (in < 5.0 ? 5.0 : (in < 10.0 ? 10.0 : (in < 25.0 ? 25.0 : (in < 50.0 ? 50.0 : (in < 100.0 ? 100.0 : (in < 250.0 ? 250.0 : (in < 500.0 ? 500.0 : (in < 1000.0 ? 1000.0 : (in < 2500.0 ? 2500.0 : (in < 5000.0 ? 5000.0 : (in < 10000.0 ? 10000.0 : (in < 25000.0 ? 25000.0 : (in < 50000.0 ? 50000.0 : (in < 100000.0 ? 100000.0 : (in < 250000.0 ? 250000.0 : (in < 500000.0 ? 500000.0 : (in < 1000000.0 ? 1000000.0 : (in < 2500000.0 ? 2500000.0 : (in < 5000000.0 ? 5000000.0 : (in < 1.0E7 ? 1.0E7 : (in < 2.5E7 ? 2.5E7 : (in < 5.0E7 ? 5.0E7 : (in < 1.0E8 ? 1.0E8 : (in < 2.5E8 ? 2.5E8 : (in < 5.0E8 ? 5.0E8 : 1.0E9)))))))))))))))))))))))))))));
        in = 0.0;
        y = y0 - (int)((double)h0 * in / (double)maxInt * (double)m_2dGain);
        while (y > y0 - h0) {
            x = x0;
            y = y0 - (int)((double)h0 * in / (double)maxInt * (double)m_2dGain);
            if (y < y0 - h0 + 10 || in > 2.147483E9) break;
            int tickLen = 3;
            if (thickChrom_) {
                tickLen = 12;
            }
            gx.drawLine(x, y, x - tickLen, y);
            s = Integer.toString((int)in);
            if (in < 1.0 && in > 0.0 || in > 1.0 && in < 2.0 || in > 2.0 && in < 3.0 || in > 7.0 && in < 8.0) {
                s = Double.toString(in);
            }
            if (in > 999.0) {
                s = Calculator.scientificFormat(in);
            }
            sw = fm.stringWidth(s);
            if (drawLegend) {
                int posX = x - sw - 4;
                int posY = y;
                if (in == 0.0) {
                    posY = y + 4;
                }
                if (thickChrom_) {
                    posX -= 12;
                    posY = y + 12;
                }
                gx.drawString(s, posX, posY);
            }
            in += din;
        }
        if (relativeValue) {
            j = fm.stringWidth("Relative abundance [%]");
            double standRotAngle = -1.5707963267948966;
            ((Graphics2D)gx).rotate(standRotAngle);
            gx.drawString("Relative abundance [%]", (h0 - j) / 2 - y0, x / 2 + fm.getHeight() / 2);
            ((Graphics2D)gx).rotate(-standRotAngle);
        } else {
            j = fm.stringWidth("Intensity / cts");
            int posX = x - j - 4;
            int posY = y0 - h0 + 6;
            if (thickChrom_) {
                posX -= 12;
                posY += 12;
            }
            if (drawLegend) {
                gx.drawString("Intensity / AU", posX, posY);
            }
        }
        if (ms2Position != null) {
            float[][] values = new float[1][4];
            values[0][0] = ms2Position.floatValue();
            if (displayTime == 1) {
                values[0][0] = ms2Position.floatValue() * 60.0f;
            }
            values[0][1] = maxIntensity;
            values[0][2] = maxIntensity;
            int[] coords = Lipidomics2DPainter.getCoordinatesInDiagram(values, 0, x0, y0, w0, h0, m_minDispTime2d, m_maxDispTime2d, maxIntensity, m_2dGain, raw, relativeValue, stopAtH0);
            gx.setColor(Color.BLUE);
            gx.drawLine(coords[0], y0, coords[0], coords[1]);
            gx.setColor(Color.BLACK);
        }
    }

    private LipidomicsChromatogram extractChromatogram(float start, float stop) {
        int i;
        int stopIndex;
        int startIndex = this.getDataIndex(start);
        if (startIndex < 1) {
            startIndex = 0;
        }
        if ((stopIndex = this.getDataIndex(stop)) >= this.dataStrings_.length) {
            stopIndex = this.dataStrings_.length;
        }
        Hashtable<Integer, Float> rts = this.retentionTimes_;
        if (this.doSparseCorrection_) {
            rts = this.retentionTimesOriginal_;
        }
        LipidomicsChromatogram chrom = new LipidomicsChromatogram(rts.size());
        chrom.LowerMzBand = this.stepSize_ / 2.0f;
        chrom.UpperMzBand = this.stepSize_ / 2.0f;
        chrom.Mz = (start + stop) / 2.0f;
        for (i = 0; i != rts.size(); ++i) {
            chrom.Value[i][0] = rts.get(new Integer(i)).floatValue();
            chrom.Value[i][1] = 0.0f;
        }
        if (this.dataStrings_ != null) {
            if (startIndex < 0) {
                startIndex = 0;
            }
            for (i = startIndex; i < stopIndex && i != this.dataStrings_.length; ++i) {
                if (this.dataStrings_[i] == null || this.dataStrings_[i].length() <= 0) continue;
                ByteBuffer buffer = ByteBuffer.wrap(Base64.decode(this.dataStrings_[i]));
                while (buffer.hasRemaining()) {
                    int scanNumber = buffer.getInt();
                    float intensity = buffer.getFloat();
                    float[] fArray = chrom.Value[scanNumber];
                    fArray[1] = fArray[1] + intensity;
                    if (!(chrom.Value[scanNumber][1] > this.maxIntensity_)) continue;
                    this.maxIntensity_ = chrom.Value[scanNumber][1];
                }
            }
        }
        if (this.doSparseCorrection_) {
            chrom.doChromValueInterpolation(this.retentionTimes_);
        }
        chrom.Smooth(LipidomicsConstants.getChromSmoothRange(), LipidomicsConstants.getChromSmoothRepeats());
        chrom.GetMaximumAndAverage();
        return chrom;
    }

    protected static void drawDiagramItself(Graphics gx, CgChromatogram cr, int x0, int y0, int w0, int h0, float m_minDispTime2d, float m_maxDispTime2d, float maxIntensity, float m_2dGain, boolean raw, boolean relativeValue, boolean barChart, Vector<RangeColor> rangeColors, boolean stopAtH0) {
        if (thickChrom_) {
            ((Graphics2D)gx).setStroke(new BasicStroke(3.0f));
        }
        int x = 0;
        int y = 0;
        int xx = 0;
        int yy = 0;
        gx.setColor(Color.BLACK);
        boolean firstPoint = true;
        int len = cr.Value.length;
        for (int i = 0; i < len; ++i) {
            if (cr.Value[i][0] < m_minDispTime2d || cr.Value[i][0] > m_maxDispTime2d) continue;
            int[] coords = Lipidomics2DPainter.getCoordinatesInDiagram(cr.Value, i, x0, y0, w0, h0, m_minDispTime2d, m_maxDispTime2d, maxIntensity, m_2dGain, raw, relativeValue, stopAtH0);
            x = coords[0];
            y = coords[1];
            if (firstPoint) {
                xx = x;
                yy = y;
                firstPoint = false;
            }
            if (rangeColors != null && rangeColors.size() > 0) {
                RangeColor rangeVO = Lipidomics2DPainter.getColorAccordingToXPos(cr.Value[i][0], rangeColors);
                if (rangeVO != null) {
                    gx.setColor(rangeVO.getColor());
                } else {
                    gx.setColor(Color.BLACK);
                }
            }
            if (barChart) {
                gx.drawLine(x, y0, x, y < 0 ? 0 : y);
            } else {
                gx.drawLine(xx, yy, x, y);
            }
            xx = x;
            yy = y;
        }
        gx.setColor(Color.BLACK);
    }

    protected static RangeColor getColorAccordingToXPos(float x, Vector<RangeColor> rangeColors) {
        for (RangeColor vo : rangeColors) {
            if (!vo.insideRange(x)) continue;
            return vo;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.draw2DDiagram(g);
        this.setInputLocations();
        this.showFields();
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        this.hideFields();
        super.reshape(x, y, width, height);
    }

    public void hideFields() {
        if (this.m_txtTime.isVisible()) {
            if (this.m_txtMz != null) {
                this.m_txtMz.setVisible(false);
            }
            this.m_txtTime.setVisible(false);
            this.m_txtIntensity.setVisible(false);
            this.m_plusGain.setVisible(false);
            this.m_minusGain.setVisible(false);
            this.m_plusShift.setVisible(false);
            this.m_minusShift.setVisible(false);
        }
    }

    public void showFields() {
        if (!this.m_txtTime.isVisible()) {
            if (this.m_txtMz != null) {
                this.m_txtMz.setVisible(true);
            }
            this.m_txtTime.setVisible(true);
            this.m_txtIntensity.setVisible(true);
            this.m_plusGain.setVisible(true);
            this.m_minusGain.setVisible(true);
            this.m_plusShift.setVisible(true);
            this.m_minusShift.setVisible(true);
        }
    }

    private int getDataIndex(float mzValue) {
        String toCut = String.valueOf(Calculator.roundFloat((mzValue - this.mzStart_) * (float)this.resolutionFactor_, 0));
        return Integer.parseInt(toCut.substring(0, toCut.indexOf(".")));
    }

    protected int leftMargin_2d() {
        return 75;
    }

    private int rightMargin_2d() {
        return 15;
    }

    private static int topMargin_2d() {
        return 5;
    }

    protected int bottomMargin_2d() {
        return 20;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equalsIgnoreCase("Plus2dGain")) {
            this.m_2dGain_ *= 1.1f;
            this.update(this.getGraphics());
        }
        if (command.equalsIgnoreCase("Minus2dGain")) {
            this.m_2dGain_ /= 1.1f;
            this.update(this.getGraphics());
        }
        if (command.equalsIgnoreCase("Plus2dShift")) {
            this.set2dShift(1);
            this.update(this.getGraphics());
        }
        if (command.equalsIgnoreCase("Minus2dShift")) {
            this.set2dShift(-1);
            this.update(this.getGraphics());
        }
        if (e.getActionCommand() == "Determine Area") {
            this.determineArea(LipidomicsDefines.StandardValleyMethod);
            return;
        }
        if (e.getActionCommand() == "Determine Area (Col)") {
            this.determineArea(LipidomicsDefines.EnhancedValleyMethod);
            return;
        }
        if (e.getActionCommand() == "Determine Area (Greedy)") {
            this.determineArea(LipidomicsDefines.GreedySteepnessReductionMethod);
            return;
        }
        if (e.getActionCommand() == "Delete Area") {
            this.deleteArea();
        } else if (e.getActionCommand().equalsIgnoreCase("Enter probe borders")) {
            CgProbe usrPr = this.getUserProbe(this.lastPopupX);
            CgProbe sysPr = this.getSystemProbe(this.lastPopupX);
            boolean threeD = false;
            float mzStart = this.chromMzStart_;
            float mzStop = this.chromMzStop_;
            float time = this.getRetentionTime(this.lastPopupX);
            float timeStart = time - 60.0f;
            float timeStop = time + 60.0f;
            if (usrPr != null || sysPr != null) {
                if (usrPr != null) {
                    this.probeToAdjust_ = usrPr;
                    this.isProbeToAdjustSystemProbe_ = false;
                } else {
                    this.probeToAdjust_ = sysPr;
                    this.isProbeToAdjustSystemProbe_ = true;
                }
                timeStart = this.probeToAdjust_.LowerValley;
                timeStop = this.probeToAdjust_.UpperValley;
                if (this.probeToAdjust_ instanceof Probe3D) {
                    threeD = true;
                    Probe3D probe3D = (Probe3D)this.probeToAdjust_;
                    mzStart = probe3D.getEllipseMzPosition() - probe3D.getEllipseMzStretch();
                    mzStop = probe3D.getEllipseMzPosition() + probe3D.getEllipseMzStretch();
                    timeStart = probe3D.getEllipseTimePosition() - probe3D.getEllipseTimeStretch();
                    timeStop = probe3D.getEllipseTimePosition() + probe3D.getEllipseTimeStretch();
                }
            } else {
                this.probeToAdjust_ = null;
            }
            if (timeStart < this.m_minDispTime2d_) {
                timeStart = this.m_minDispTime2d_;
            }
            if (timeStop > this.m_maxDispTime2d_) {
                timeStop = this.m_maxDispTime2d_;
            }
            this.areaSettings_.setInputFields(threeD, timeStart /= this.timeCorrectionFactor_, timeStop /= this.timeCorrectionFactor_, mzStart, mzStop);
            this.areaSettings_.setVisible(true);
        } else if (e.getActionCommand().equalsIgnoreCase("acceptAreaSettings")) {
            this.acceptAreaSettings();
            if (this.superiorListener_ != null) {
                this.superiorListener_.actionPerformed(e);
            }
        } else if (e.getActionCommand().equalsIgnoreCase("discardAreaSettings")) {
            this.areaSettings_.setVisible(false);
        }
    }

    private void acceptAreaSettings() {
        AreaSettingVO settings = this.areaSettings_.getInputValues();
        if (settings.getStartTime() * (double)this.timeCorrectionFactor_ < 0.0) {
            new WarningMessage(new JFrame(), "Error", "Your start-time must be greater than 0!");
        } else if (settings.getStopTime() * (double)this.timeCorrectionFactor_ > (double)(this.m_maxDispTime2d_ + 30.0f)) {
            new WarningMessage(new JFrame(), "Error", "Your stop-time must not be greater than " + this.m_maxDispTime2d_ / this.timeCorrectionFactor_ + "! This is outside the range");
        } else if (settings.getStartTime() >= settings.getStopTime()) {
            new WarningMessage(new JFrame(), "Error", "Your start-time must not be greater or equal your stop-time!");
        } else if (settings.getStartMz() < (double)this.mzStart_) {
            new WarningMessage(new JFrame(), "Error", "Your start-m/z must not be lower than " + this.mzStart_ + "! This is outside the range");
        } else if (settings.getStopMz() > (double)this.mzStop_) {
            new WarningMessage(new JFrame(), "Error", "Your stop-m/z must not be greater than " + this.mzStop_ + "! This is outside the range");
        } else if (settings.getStartMz() >= settings.getStopMz()) {
            new WarningMessage(new JFrame(), "Error", "Your start-m/z must not be greater or equal your stop-m/z!");
        } else {
            CgProbe probeToAdd = this.createManuallyAddedProbe(settings);
            this.areaSettings_.setVisible(false);
            probeToAdd.isotopeNumber = this.isotopeNumber_;
            this.addProbeToTheCache(probeToAdd);
        }
    }

    public void setRaw(boolean raw) {
        this.raw_ = raw;
    }

    public boolean setMinDispTime2d(float newVal) {
        float newVal2 = newVal * this.timeCorrectionFactor_;
        if (newVal2 < 0.0f) {
            return false;
        }
        if (newVal2 < this.m_minTime_) {
            newVal2 = this.m_minTime_;
        }
        this.m_minDispTime2d_ = newVal2;
        if (this.m_minDispTime2d_ < this.m_maxTime_ / 100.0f) {
            this.m_minDispTime2d_ = 0.0f;
        }
        return true;
    }

    public boolean setMaxDispTime2d(float newVal) {
        float newVal2 = newVal * this.timeCorrectionFactor_;
        if (newVal2 < this.m_minDispTime2d_) {
            return false;
        }
        if (newVal2 > this.m_maxTime_) {
            newVal2 = this.m_maxTime_;
        }
        this.m_maxDispTime2d_ = newVal2;
        return true;
    }

    public void zoomAll() {
        this.m_minDispTime2d_ = this.m_minTime_;
        this.m_maxDispTime2d_ = this.m_maxTime_;
        if (this.m_minDispTime2d_ < this.m_maxTime_ / 100.0f) {
            this.m_minDispTime2d_ = 0.0f;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setShownIntensity(this.getIntensity(e.getY()));
        this.setShownRetentionTime(this.getRetentionTime(e.getX()));
        if (this.leftMouseClickLocationX_ > -1) {
            // empty if block
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(this.m_crosshair);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getDefaultCursor());
        this.m_txtIntensity.setText("");
        this.m_txtTime.setText("");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.leftMouseClickLocationX_ = e.getX();
            this.leftMouseClickLocationY_ = e.getY();
            this.paintTriangle(this.leftMouseClickLocationX_, this.leftMouseClickLocationY_);
        }
    }

    private void paintTriangle(int x, int y) {
        Graphics graphics = this.getGraphics();
        this.triangleWrite(graphics, x, y);
    }

    private void eraseTriangle(int x, int y) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.white);
        this.triangleWrite(graphics, x, y);
        graphics.setColor(Color.black);
    }

    private void triangleWrite(Graphics graphics, int x, int y) {
        graphics.drawLine(this.leftMouseClickLocationX_ - 8, this.leftMouseClickLocationY_ - 5, this.leftMouseClickLocationX_, this.leftMouseClickLocationY_);
        graphics.drawLine(this.leftMouseClickLocationX_ + 8, this.leftMouseClickLocationY_ - 5, this.leftMouseClickLocationX_, this.leftMouseClickLocationY_);
        graphics.drawLine(this.leftMouseClickLocationX_ - 8, this.leftMouseClickLocationY_ - 5, this.leftMouseClickLocationX_ + 8, this.leftMouseClickLocationY_ - 5);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.leftMouseClickLocationX_ > -1) {
            this.eraseTriangle(this.leftMouseClickLocationX_, this.leftMouseClickLocationY_);
            this.leftMouseClickLocationX_ = -1;
            this.leftMouseClickLocationY_ = -1;
        }
        if (e.isPopupTrigger() || e.getButton() == 3) {
            if (this.checkPopupClick(e.getX(), e.getY()) == 0) {
                return;
            }
            boolean usrPr = this.anyUserProbeThere(e.getX());
            boolean sysPr = this.anySystemProbeThere(e.getX());
            this.m_deleteUserProbe.setEnabled(usrPr || sysPr);
            this.m_addUserProbe1.setEnabled(!sysPr && !usrPr);
            if (!this.shotgun_) {
                this.m_addUserProbe2.setEnabled(!sysPr && !usrPr);
                this.m_addUserProbe3.setEnabled(!sysPr && !usrPr);
                this.m_addUserProbe4.setEnabled(!sysPr && !usrPr);
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.lastPopupX = e.getX();
            this.lastPopupY = e.getY();
            this.m_popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void setShownIntensity(float newVal) {
        if (newVal >= 0.0f) {
            float value = newVal;
            value = Lipidomics2DPainter.getCorrespondingValue(value, this.maxIntensity_, this.raw_, this.relativeIntensity_);
            String s = String.format("Int = %4.3e", Float.valueOf(value));
            s = s.replace("+", "").replace("e0", "e");
            this.m_txtIntensity.setText(s);
        } else {
            this.m_txtIntensity.setText("");
        }
    }

    protected float getIntensity(int y) {
        if (y < Lipidomics2DPainter.topMargin_2d()) {
            return -1.0f;
        }
        int h0 = this.diagramHeight_2d();
        if (y > Lipidomics2DPainter.topMargin_2d() + h0) {
            return -1.0f;
        }
        return (float)(h0 + Lipidomics2DPainter.topMargin_2d() - y) * this.maxIntensity_ * 1.05f / this.m_2dGain_ / (float)h0;
    }

    protected float getRetentionTime(int x) {
        if (x < this.leftMargin_2d()) {
            return -1.0f;
        }
        int w0 = this.diagramWidth_2d();
        if (x > this.leftMargin_2d() + w0) {
            return -1.0f;
        }
        return this.m_minDispTime2d_ + (float)(x - this.leftMargin_2d()) * (this.m_maxDispTime2d_ - this.m_minDispTime2d_) / (float)w0;
    }

    public void setShownRetentionTime(float newVal) {
        if (newVal >= 0.0f) {
            float time = newVal / this.timeCorrectionFactor_;
            String value = "";
            if (this.displayTime_ == 0) {
                value = String.valueOf(Calculator.roundFloat(time, 0));
            }
            if (this.displayTime_ == 1) {
                value = String.valueOf(Calculator.roundFloat(time, 2));
            }
            String s = value;
            this.m_txtTime.setText("t = " + s);
        } else {
            this.m_txtTime.setText("");
        }
    }

    private void set2dShift(int direction) {
        float diff = this.m_maxDispTime2d_ - this.m_minDispTime2d_;
        float delta = diff / 40.0f;
        if (direction < 0) {
            float x = this.m_minDispTime2d_ - delta;
            if (x < 0.0f) {
                x = 0.0f;
            }
            this.m_minDispTime2d_ = x;
            this.m_maxDispTime2d_ = x + diff;
        } else {
            float x = this.m_maxDispTime2d_ + delta;
            if (x > this.m_maxTime_) {
                x = this.m_maxTime_;
            }
            this.m_maxDispTime2d_ = x;
            this.m_minDispTime2d_ = x - diff;
        }
    }

    public void nextChromatogram() {
        int diff = this.currentStop_ - this.currentStart_;
        if (Float.valueOf(this.currentStop_ + diff).floatValue() / (float)this.resolutionFactor_ <= this.mzStop_) {
            this.currentStart_ += diff;
            this.currentStop_ += diff;
            this.cr_ = null;
        }
    }

    public void previousChromatogram() {
        int diff = this.currentStop_ - this.currentStart_;
        if (Float.valueOf(this.currentStart_ - diff).floatValue() / (float)this.resolutionFactor_ >= this.mzStart_) {
            this.currentStart_ -= diff;
            this.currentStop_ -= diff;
            this.cr_ = null;
        }
    }

    public float getLowerMz() {
        return Float.valueOf(this.currentStart_).floatValue() / (float)this.resolutionFactor_;
    }

    public float getUpperMz() {
        return Float.valueOf(this.currentStop_).floatValue() / (float)this.resolutionFactor_;
    }

    private void paint2dAreas(Vector<CgProbe> areas, Color col) {
        this.paint2dAreas(this.getGraphics(), areas, col);
    }

    private void paint2dAreas(Graphics g, Vector<CgProbe> areas, Color col) {
        int x0 = this.leftMargin_2d();
        int w0 = this.diagramWidth_2d();
        int y0 = Lipidomics2DPainter.topMargin_2d() + this.diagramHeight_2d();
        int h0 = this.diagramHeight_2d();
        Lipidomics2DPainter.paint2dAreas(g, this.cr_, areas, col, this.isotopeNumber_, x0, y0, w0, h0, this.m_minDispTime2d_, this.m_maxDispTime2d_, this.maxIntensity_, this.m_2dGain_, this.raw_, true);
    }

    private static void paint2dAreas(Graphics gx, CgChromatogram cr, Vector<CgProbe> areas, Color col, int isotopeNumber, int x0, int y0, int w0, int h0, float m_minDispTime2d, float m_maxDispTime2d, float maxIntensity, float m_2dGain, boolean raw, boolean displayLegend) {
        int x = 0;
        int y = 0;
        float maxInt = maxIntensity;
        maxInt *= 1.05f;
        int len = cr.Value.length;
        for (CgProbe cp : areas) {
            float value;
            if (cp == null || cp.AreaStatus != CgAreaStatus.OK || cp.isotopeNumber != isotopeNumber) continue;
            Polygon p = new Polygon();
            boolean firstPoint = true;
            int nearestScanNumber = 0;
            for (int j = 0; j < len; ++j) {
                if (cr.Value[j][0] < m_minDispTime2d || cr.Value[j][0] < cp.LowerValley || cr.Value[j][0] > m_maxDispTime2d || cr.Value[j][0] > cp.UpperValley) continue;
                if (cr.Value[j][0] < cp.Peak) {
                    nearestScanNumber = j;
                }
                x = x0 + (int)((float)w0 * (cr.Value[j][0] - m_minDispTime2d) / (m_maxDispTime2d - m_minDispTime2d));
                value = Lipidomics2DPainter.getCorrespondingValue(cr.Value[j], maxIntensity, raw, false);
                y = y0 - (int)((float)h0 * value * m_2dGain / maxInt);
                if (firstPoint) {
                    p.addPoint(x, y0);
                    firstPoint = false;
                }
                p.addPoint(x, y);
            }
            if (p.npoints <= 0) continue;
            p.addPoint(x, y0);
            gx.setColor(col);
            gx.fillPolygon(p);
            x = x0 + (int)((float)w0 * (cp.Peak - m_minDispTime2d) / (m_maxDispTime2d - m_minDispTime2d));
            value = Lipidomics2DPainter.getCorrespondingValue(cr.Value[nearestScanNumber], maxIntensity, raw, false);
            y = y0 - (int)((float)h0 * value * m_2dGain / maxInt) - 5;
            if (y < 30) {
                y = 30;
                x += 10;
            }
            String s = String.format("A=%4.3e", Float.valueOf(cp.Area));
            s = s.replace("+", "") + " @ " + Calculator.roundFloat(cp.LowerValley / 60.0f, 2) + "<t<" + Calculator.roundFloat(cp.UpperValley / 60.0f, 2);
            s = s.replace("e0", "e").replace(",", ".");
            gx.setColor(Color.BLUE);
            if (!displayLegend || thickChrom_) continue;
            gx.drawString(s, x, y);
        }
    }

    protected int diagramWidth_2d() {
        return this.getWidth() - this.leftMargin_2d() - this.rightMargin_2d();
    }

    protected int diagramHeight_2d() {
        return this.getHeight() - Lipidomics2DPainter.topMargin_2d() - this.bottomMargin_2d();
    }

    private double getThreshold() {
        return this.stepSize_ / 50.0f;
    }

    private boolean in2dDiagram(int x, int y) {
        if (x < this.leftMargin_2d()) {
            return false;
        }
        if (x > this.leftMargin_2d() + this.diagramWidth_2d()) {
            return false;
        }
        if (y < Lipidomics2DPainter.topMargin_2d()) {
            return false;
        }
        return y <= Lipidomics2DPainter.topMargin_2d() + this.diagramHeight_2d();
    }

    public int checkPopupClick(int x, int y) {
        if (!this.in2dDiagram(x, y)) {
            return 0;
        }
        float t = this.getRetentionTime(x);
        float intensity = this.getIntensity(y);
        for (int i = 1; i < this.cr_.Value.length; ++i) {
            float ix;
            if (this.cr_.Value[i][0] < t) continue;
            float n = this.cr_.Value[i][0] - this.cr_.Value[i - 1][0];
            if (!this.raw_) {
                float z = this.cr_.Value[i][2] - this.cr_.Value[i - 1][2];
                ix = this.cr_.Value[i - 1][2] + z / n * (t - this.cr_.Value[i - 1][0]);
            } else {
                float z = this.cr_.Value[i][1] - this.cr_.Value[i - 1][1];
                ix = this.cr_.Value[i - 1][1] + z / n * (t - this.cr_.Value[i - 1][0]);
            }
            if (intensity < ix) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public boolean anyUserProbeThere(int x) {
        CgProbe cp = this.getUserProbe(x);
        return cp != null;
    }

    public CgProbe getUserProbe(int x) {
        float t = this.getRetentionTime(x);
        for (int i = 0; i < this.selectedProbes_.size(); ++i) {
            CgProbe cp = this.selectedProbes_.get(i);
            if (cp.LowerValley > t || cp.UpperValley < t || cp.isotopeNumber != this.isotopeNumber_) continue;
            return cp;
        }
        return null;
    }

    public boolean anySystemProbeThere(int x) {
        CgProbe cp = this.getSystemProbe(x);
        return cp != null;
    }

    public CgProbe getSystemProbe(int x) {
        float t = this.getRetentionTime(x);
        for (int i = 0; i < this.storedProbes_.size(); ++i) {
            CgProbe cp = this.storedProbes_.get(i);
            if (cp.LowerValley > t || cp.UpperValley < t || cp.isotopeNumber != this.isotopeNumber_) continue;
            boolean removed = false;
            for (int j = 0; j != this.removedStoredProbes_.size(); ++j) {
                if (!this.sameCgProbe(this.removedStoredProbes_.get(j), cp)) continue;
                removed = true;
            }
            if (!removed) {
                return cp;
            }
            return null;
        }
        return null;
    }

    private void removeStoredArea(int x) {
        float t = this.getRetentionTime(x);
        for (int i = 0; i < this.storedProbes_.size(); ++i) {
            CgProbe cp = this.storedProbes_.get(i);
            if (cp.LowerValley > t || cp.UpperValley < t || cp.isotopeNumber != this.isotopeNumber_) continue;
            this.removedStoredProbes_.add(cp);
            break;
        }
        this.draw2DDiagram(Float.valueOf(String.valueOf(this.currentStart_)).floatValue() / (float)this.resolutionFactor_, Float.valueOf(String.valueOf(this.currentStop_)).floatValue() / (float)this.resolutionFactor_, this.raw_);
        this.update(this.getGraphics());
    }

    private boolean sameCgProbe(CgProbe probe1, CgProbe probe2) {
        boolean ok = false;
        if ((double)probe1.Area >= (double)probe2.Area - 0.02 && (double)probe1.Area <= (double)probe2.Area + 0.02 && (double)probe1.AreaError >= (double)probe2.AreaError - 0.02 && (double)probe1.AreaError <= (double)probe2.AreaError + 0.02 && (double)probe1.Background >= (double)probe2.Background - 0.02 && (double)probe1.Background <= (double)probe2.Background + 0.02 && probe1.Charge == probe2.Charge && (double)probe1.LowerMzBand >= (double)probe2.LowerMzBand - this.getThreshold() && (double)probe1.LowerMzBand <= (double)probe2.LowerMzBand + this.getThreshold() && (double)probe1.LowerValley >= (double)probe2.LowerValley - 0.02 && (double)probe1.LowerValley <= (double)probe2.LowerValley + 0.02 && (double)probe1.Mz >= (double)probe2.Mz - this.getThreshold() && (double)probe1.Mz <= (double)probe2.Mz + this.getThreshold() && (double)probe1.Peak >= (double)probe2.Peak - 0.02 && (double)probe1.Peak <= (double)probe2.Peak + 0.02 && (double)probe1.UpperMzBand >= (double)probe2.UpperMzBand - this.getThreshold() && (double)probe1.UpperMzBand <= (double)probe2.UpperMzBand + this.getThreshold() && (double)probe1.UpperValley >= (double)probe2.UpperValley - 0.02 && (double)probe1.UpperValley <= (double)probe2.UpperValley + 0.02) {
            ok = true;
        }
        return ok;
    }

    private void deleteArea(int x) {
        float t = this.getRetentionTime(x);
        for (int i = 0; i < this.selectedProbes_.size(); ++i) {
            CgProbe cp = this.selectedProbes_.get(i);
            if (cp.LowerValley > t || cp.UpperValley < t || cp.isotopeNumber != this.isotopeNumber_) continue;
            this.selectedProbes_.remove(cp);
            break;
        }
        this.draw2DDiagram(Float.valueOf(String.valueOf(this.currentStart_)).floatValue() / (float)this.resolutionFactor_, Float.valueOf(String.valueOf(this.currentStop_)).floatValue() / (float)this.resolutionFactor_, this.raw_);
        this.update(this.getGraphics());
    }

    private void determineArea(int x, int method) {
        float t = this.getRetentionTime(x);
        CgProbe cx = null;
        if (this.shotgun_) {
            cx = LipidomicsAnalyzer.calculateAShotgunIntensity(this.cr_, this.charge_, this.msLevel_, LipidomicsConstants.getShogunProcessing());
        } else if (method == LipidomicsDefines.Valley3DMethod) {
            try {
                cx = this.analyzer_.detectPeakThreeD(this.cr_, LipidomicsAnalyzer.findIndexByTime(t, this.cr_), false, this.charge_, this.msLevel_);
            }
            catch (CgException e) {
                e.printStackTrace();
            }
            catch (QuantificationException qcx) {
                WarningMessage dlg = new WarningMessage(new JFrame(), "Warning", qcx.getMessage());
                return;
            }
        } else {
            cx = LipidomicsAnalyzer.calculateOneArea(this.cr_, LipidomicsAnalyzer.findIndexByTime(t, this.cr_), method, this.charge_);
        }
        cx.isotopeNumber = this.isotopeNumber_;
        if (cx.AreaStatus != CgAreaStatus.OK) {
            WarningMessage dlg = new WarningMessage(new JFrame(), "Warning", "The selected peak is too small to be valid");
            return;
        }
        this.addProbeToTheCache(cx);
    }

    private void addProbeToTheCache(CgProbe cx) {
        if (!this.isRemovedSystemProbeThere(cx)) {
            CgProbe overlappingProbe = this.overlappingToOtherProbe(cx);
            if (overlappingProbe != null) {
                WarningMessage warningMessage = new WarningMessage(new JFrame(), "Warning", "The selected probe area will overlap with the area " + overlappingProbe.Area + "; start: " + cx.LowerValley / 60.0f + "min stop: " + cx.UpperValley / 60.0f + "min");
            } else {
                this.selectedProbes_.add(cx);
            }
        }
        this.draw2DDiagram(Float.valueOf(String.valueOf(this.currentStart_)).floatValue() / (float)this.resolutionFactor_, Float.valueOf(String.valueOf(this.currentStop_)).floatValue() / (float)this.resolutionFactor_, this.raw_);
        this.update(this.getGraphics());
    }

    private boolean isRemovedSystemProbeThere(CgProbe newProbe) {
        boolean isThere = false;
        int count = 0;
        int position = -1;
        for (CgProbe aProbe : this.removedStoredProbes_) {
            if (this.sameCgProbe(newProbe, aProbe)) {
                isThere = true;
                position = count;
            }
            ++count;
        }
        if (isThere) {
            this.removedStoredProbes_.remove(position);
        }
        return isThere;
    }

    private CgProbe overlappingToOtherProbe(CgProbe newProbe) {
        CgProbe overlapProbe = null;
        for (CgProbe aProbe : this.storedProbes_) {
            if (!((double)newProbe.Mz > (double)aProbe.Mz - this.getThreshold()) || !((double)newProbe.Mz < (double)aProbe.Mz + this.getThreshold()) || !(newProbe.UpperValley > aProbe.LowerValley && newProbe.LowerValley < aProbe.LowerValley || newProbe.LowerValley < aProbe.LowerValley && newProbe.UpperValley > aProbe.UpperValley || newProbe.LowerValley + 1.0f > aProbe.LowerValley && newProbe.UpperValley - 1.0f < aProbe.UpperValley) && (!(newProbe.LowerValley - 1.0f < aProbe.LowerValley) || !(newProbe.UpperValley + 1.0f > aProbe.UpperValley))) continue;
            boolean isRemovedOverlapProbe = false;
            for (CgProbe probe : this.removedStoredProbes_) {
                if (!(probe.Area + 1.0f > aProbe.Area) || !(probe.Area - 1.0f < aProbe.Area)) continue;
                isRemovedOverlapProbe = true;
            }
            if (isRemovedOverlapProbe) continue;
            overlapProbe = aProbe;
        }
        for (CgProbe aProbe : this.selectedProbes_) {
            if (!((double)newProbe.Mz > (double)aProbe.Mz - this.getThreshold()) || !((double)newProbe.Mz < (double)aProbe.Mz + this.getThreshold()) || !(newProbe.UpperValley > aProbe.LowerValley && newProbe.LowerValley < aProbe.LowerValley || newProbe.LowerValley < aProbe.LowerValley && newProbe.UpperValley > aProbe.UpperValley || newProbe.LowerValley + 1.0f > aProbe.LowerValley && newProbe.UpperValley - 1.0f < aProbe.UpperValley) && (!(newProbe.LowerValley - 1.0f < aProbe.LowerValley) || !(newProbe.UpperValley + 1.0f > aProbe.UpperValley))) continue;
            overlapProbe = aProbe;
        }
        return overlapProbe;
    }

    public void determineArea(int mode) {
        this.determineArea(this.lastPopupX, mode);
    }

    public void deleteArea() {
        if (this.anySystemProbeThere(this.lastPopupX)) {
            this.removeStoredArea(this.lastPopupX);
        } else {
            this.deleteArea(this.lastPopupX);
        }
    }

    public Vector<Vector<CgProbe>> getAllSelectedProbes() {
        Vector<Vector<CgProbe>> allProbes = new Vector<Vector<CgProbe>>();
        Vector<CgProbe> storedProbes = new Vector<CgProbe>();
        for (CgProbe probe : this.storedProbes_) {
            boolean isRemoved = false;
            for (CgProbe removedProbe : this.removedStoredProbes_) {
                if (!this.sameCgProbe(probe, removedProbe)) continue;
                isRemoved = true;
            }
            if (isRemoved) continue;
            storedProbes.add(probe);
        }
        allProbes.add(storedProbes);
        allProbes.add(this.selectedProbes_);
        return allProbes;
    }

    public void setStoredProbes(Vector<CgProbe> probes) {
        this.storedProbes_ = probes;
        this.selectedProbes_ = new Vector();
        this.removedStoredProbes_ = new Vector();
        this.draw2DDiagram(Float.valueOf(String.valueOf(this.currentStart_)).floatValue() / (float)this.resolutionFactor_, Float.valueOf(String.valueOf(this.currentStop_)).floatValue() / (float)this.resolutionFactor_, this.raw_);
        this.update(this.getGraphics());
    }

    private CgProbe createManuallyAddedProbe(AreaSettingVO settings) {
        CgProbe probeToAdd = null;
        double startTime = settings.getStartTime() * (double)this.timeCorrectionFactor_;
        double stopTime = settings.getStopTime() * (double)this.timeCorrectionFactor_;
        if (this.probeToAdjust_ != null) {
            if (this.isProbeToAdjustSystemProbe_) {
                this.removeStoredArea(this.lastPopupX);
            } else {
                this.deleteArea();
            }
        }
        try {
            probeToAdd = this.analyzer_.getProbeByManualSettings(this.cr_, settings.isThreeD(), startTime, stopTime, (float)settings.getStartMz(), (float)settings.getStopMz(), this.charge_, this.msLevel_);
        }
        catch (CgException e) {
            e.printStackTrace();
        }
        return probeToAdd;
    }

    private static float getCorrespondingValue(float[] valueArray, float maxIntensity, boolean raw, boolean relativeValue) {
        float value = 0.0f;
        value = raw ? valueArray[1] : valueArray[2];
        return Lipidomics2DPainter.getCorrespondingValue(value, maxIntensity, raw, relativeValue);
    }

    private static float getCorrespondingValue(float oldValue, float maxIntensity, boolean raw, boolean relativeValue) {
        float value = oldValue;
        if (relativeValue) {
            value = value * 100.0f / maxIntensity;
        }
        return value;
    }

    public void setRelativeValues(boolean relativeValues) {
        this.relativeIntensity_ = relativeValues;
    }

    protected static int[] getCoordinatesInDiagram(float[][] chromValues, int pos, int x0, int y0, int w0, int h0, float m_minDispTime2d, float m_maxDispTime2d, float maxIntensity, float m_2dGain, boolean raw, boolean relativeValue, boolean stopAtH0) {
        int[] coords = new int[2];
        coords[0] = x0 + (int)((float)w0 * (chromValues[pos][0] - m_minDispTime2d) / (m_maxDispTime2d - m_minDispTime2d));
        float maxInt = Lipidomics2DPainter.getMaxInt(maxIntensity, relativeValue);
        float value = Lipidomics2DPainter.getCorrespondingValue(chromValues[pos], maxIntensity, raw, relativeValue);
        coords[1] = y0 - (int)((float)h0 * value * m_2dGain / maxInt);
        if (stopAtH0 && coords[1] < y0 - h0) {
            coords[1] = y0 - h0;
        }
        return coords;
    }

    private static float getMaxInt(float maxIntensity, boolean relativeValue) {
        float maxInt = 100.0f;
        if (!relativeValue) {
            maxInt = maxIntensity;
        }
        return maxInt *= 1.05f;
    }

    public void paintMs2Position(Float ms2Position) {
        this.ms2Position_ = ms2Position;
        this.repaint();
    }

    public float getMinDispTime2D() {
        return this.m_minTime_;
    }

    public float getMaxDispTime2D() {
        return this.m_maxTime_;
    }

    public float getM2dGain() {
        return this.m_2dGain_;
    }

    public void setM2dGain(float m_2dGain) {
        this.m_2dGain_ = m_2dGain;
    }

    public void nextSpectrum() {
    }

    public void nextSpectrum(LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors) {
    }

    public void previousSpectrum() {
    }

    public void previousSpectrum(LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors) {
    }

    public void refresh(LipidParameterSet param, Hashtable<Integer, Vector<RangeColor>> rangeColors) {
    }

    public String getSpectSelectedText() {
        return null;
    }

    public String getRtSelectedText() {
        return null;
    }

    public Vector<Double> getPrecursorMassSelected() {
        return new Vector<Double>();
    }

    public String getMsLevelSelected() {
        return null;
    }

    public float[] getRTRange() {
        return new float[2];
    }

    public int getSpectrumSelected() {
        return -1;
    }

    public int getMs2LevelSpectrumSelected() {
        return -1;
    }

    public int getMs2LevelSpectrumSelected(int specNr) {
        return -1;
    }

    public void clearRangeColors() {
    }

    public void setAnnotationThreshold(double cutoff) {
    }

    public BufferedImage getImage() {
        BufferedImage chart = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        this.draw2DDiagram(chart.getGraphics());
        return chart;
    }
}

