/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.swing.JHyperlink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HelpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public HelpPanel() {
        this.initHelpPanel();
    }

    private void initHelpPanel() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        this.add((Component)centerPanel, "Center");
        centerPanel.setLayout(new GridBagLayout());
        Font largerFont = new Font("Arial", 0, 18);
        int line = 0;
        JLabel helpText = new JLabel("User Manual");
        helpText.setFont(new Font("Arial", 1, 20));
        helpText.setToolTipText("<html>These links return the documents that describe the LDA with the aid of example data.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 10, 0), 0, 0));
        helpText = new JLabel("To access the user manual click one of these links:");
        helpText.setFont(largerFont);
        helpText.setToolTipText("<html>These links return the user manual.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        String releaseWOMinor = "2.11.0".substring(0, "2.11.0".lastIndexOf("."));
        String linkAddress = "http://genome.tugraz.at/lda2/" + releaseWOMinor + "/LDA_" + releaseWOMinor + ".pdf";
        JHyperlink linkText = new JHyperlink(linkAddress, linkAddress);
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        String baseRootPath = this.getClass().getResource("/at/tugraz/genome/lda/LipidDataAnalyzer.class").getPath();
        baseRootPath = baseRootPath.substring(0, baseRootPath.length() - "at/tugraz/genome/lda/LipidDataAnalyzer.class".length());
        if (baseRootPath.indexOf("!") > -1) {
            baseRootPath = baseRootPath.substring(0, baseRootPath.lastIndexOf("!"));
        }
        baseRootPath = baseRootPath.substring(0, baseRootPath.lastIndexOf("/"));
        String rootPath = baseRootPath + "/doc/LDA.pdf";
        if ((rootPath = rootPath.replaceAll("\\\\", "/")).indexOf("file:") != -1) {
            rootPath = rootPath.substring(rootPath.indexOf("file:") + "file:".length());
        }
        while (rootPath.startsWith("/")) {
            rootPath = rootPath.substring(1);
        }
        rootPath = "file:///" + rootPath;
        linkText = new JHyperlink("Local instance in /doc folder", rootPath);
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        helpText = new JLabel("Tutorial");
        helpText.setFont(new Font("Arial", 1, 20));
        helpText.setToolTipText("<html>These links return the documents that describe the LDA with the aid of example data.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 10, 0), 0, 0));
        helpText = new JLabel("A useful tutorial video is available here:");
        helpText.setFont(largerFont);
        helpText.setToolTipText("<html>These links return the documents that describe the LDA with the aid of example data.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        linkText = new JHyperlink("https://www.youtube.com/watch?v=GiKM-urfNIg", "https://www.youtube.com/watch?v=GiKM-urfNIg");
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        helpText = new JLabel("Study Data");
        helpText.setFont(new Font("Arial", 1, 20));
        helpText.setToolTipText("<html>These links return the documents that describe the LDA with the aid of example data.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 10, 0), 0, 0));
        helpText = new JLabel("The LC=CL RT-DB and all associated study data can be accessed via this link:");
        helpText.setFont(largerFont);
        helpText.setToolTipText("<html>These links return the documents that describe the LDA with the aid of example data.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        linkText = new JHyperlink("https://lcdbcl.github.io/", "https://lcdbcl.github.io/");
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 15, 0), 0, 0));
        helpText = new JLabel("The sphingolipid data description document for the 2020 publication can be accessed via these links:");
        helpText.setFont(largerFont);
        helpText.setToolTipText("<html>These links return the documents that describe the LDA with the aid of example data.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        linkAddress = "http://genome.tugraz.at/lda2/data/DataDescriptionSphingolipids.pdf";
        linkText = new JHyperlink(linkAddress, linkAddress);
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        rootPath = baseRootPath + "/examples/SphingolipidDataDescription.pdf";
        rootPath = rootPath.replaceAll("\\\\", "/");
        if (rootPath.indexOf("file:") != -1) {
            rootPath = rootPath.substring(rootPath.indexOf("file:") + "file:".length());
        }
        while (rootPath.startsWith("/")) {
            rootPath = rootPath.substring(1);
        }
        rootPath = "file:///" + rootPath;
        linkText = new JHyperlink("Local instance in /examples folder", rootPath);
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        helpText = new JLabel("The phospholipid data description document for the 2017 publication can be accessed via these links:");
        helpText.setFont(largerFont);
        helpText.setToolTipText("<html>These links return the documents that describe the LDA with the aid of example data.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        linkAddress = "http://genome.tugraz.at/lda2/data/DataDescription.pdf";
        linkText = new JHyperlink(linkAddress, linkAddress);
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        rootPath = baseRootPath + "/examples/DataDescription.pdf";
        rootPath = rootPath.replaceAll("\\\\", "/");
        if (rootPath.indexOf("file:") != -1) {
            rootPath = rootPath.substring(rootPath.indexOf("file:") + "file:".length());
        }
        while (rootPath.startsWith("/")) {
            rootPath = rootPath.substring(1);
        }
        rootPath = "file:///" + rootPath;
        linkText = new JHyperlink("Local instance in /examples folder", rootPath);
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        helpText = new JLabel("A comprehensive list of links to study data is available from our homepage:");
        helpText.setFont(largerFont);
        helpText.setToolTipText("<html>Link to the download of example data.<br/>ATTENTION: Not all of the data is necessary to get an idea how the LDA works!<br/>Take a look at the examples document (previous link) to avoid unnecessary downloads.</html>");
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        linkText = new JHyperlink("Link to study data download", "http://genome.tugraz.at/lda2/lda_data.shtml");
        linkText.setFont(largerFont);
        centerPanel.add((Component)linkText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        helpText = new JLabel("Please consult the examples document chapter to avoid unnecessary downloads!");
        helpText.setFont(largerFont);
        centerPanel.add((Component)helpText, new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        centerPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, line++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

