/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.swing.JHyperlink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ImageIcon ldaLogo_ = new ImageIcon(this.getClass().getResource("/images/lda_logo.png"));
    private ImageIcon ugLogo_ = new ImageIcon(this.getClass().getResource("/images/logo-RGB-uniGraz.png"));
    private ImageIcon tugLogo_ = new ImageIcon(this.getClass().getResource("/images/logo-RGB-tuGraz.png"));

    public AboutPanel() {
        this.initAboutPanel();
    }

    private void initAboutPanel() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        this.add((Component)topPanel, "North");
        topPanel.setLayout(new BorderLayout());
        JPanel logoPanel = new JPanel();
        logoPanel.setLayout(new GridBagLayout());
        topPanel.add((Component)logoPanel, "West");
        logoPanel.add((Component)new JLabel(this.ldaLogo_), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 50, 0, 0), 0, 0));
        JPanel ldaTextPanel = new JPanel(new GridBagLayout());
        this.addHeaderLabel(ldaTextPanel, "L D A", "Arial", 1, 50, 0, 0);
        this.addHeaderLabel(ldaTextPanel, "Lipid Data Analyzer", "Arial", 1, 24, 0, 1);
        logoPanel.add((Component)ldaTextPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 25, 0, 0), 0, 0));
        JPanel ldaSubtextPanel = new JPanel(new GridBagLayout());
        this.addHeaderLabel(ldaSubtextPanel, "Designed and developed by:", "Arial", 0, 18, 0, 0);
        this.addHeaderLabel(ldaSubtextPanel, "J\u00fcrgen Hartler, Alexander Triebl, Martin Tr\u00f6tzm\u00fcller, Andreas Ziegl, Leonida M. Lamp", "Arial", 0, 16, 0, 1);
        JPanel downloadPanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel downloadLabel = new JLabel("Available for download at: ");
        downloadLabel.setFont(new Font("Arial", 0, 16));
        downloadPanel.add(downloadLabel);
        JHyperlink linkText = new JHyperlink("genome.tugraz.at/lda2", "http://genome.tugraz.at/lda2");
        linkText.setFont(new Font("Arial", 0, 16));
        downloadPanel.add(linkText);
        ldaSubtextPanel.add((Component)downloadPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        JPanel publicationPanel = new JPanel(new GridBagLayout());
        JLabel publicationHeaderLabel = new JLabel("Selected Publications:");
        publicationHeaderLabel.setFont(new Font("Arial", 0, 18));
        publicationPanel.add((Component)publicationHeaderLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        String[][] publicationData = new String[][]{{"Lamp et al., Nature Communications, 2025", "doi.org/10.1038/s41467-025-61911-x"}, {"Hartler et al., Analytical Chemistry, 2020", "doi.org/10.1021/acs.analchem.0c03016"}, {"Krettler et al., Studies in Health Technology and Informatics, 2020", "doi.org/10.3233/SHTI200072"}, {"Hartler et al., Nature Methods, 2017", "doi.org/10.1038/nmeth.4470"}, {"Hartler et al., Bioinformatics, 2011", "doi.org/10.1093/bioinformatics/btq699"}};
        for (int i = 0; i < publicationData.length; ++i) {
            JLabel publicationLabel = new JLabel(publicationData[i][0]);
            publicationLabel.setFont(new Font("Arial", 0, 16));
            publicationPanel.add((Component)publicationLabel, new GridBagConstraints(0, 2 * i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            JHyperlink publicationLink = new JHyperlink(publicationData[i][1], "https://" + publicationData[i][1]);
            publicationLink.setFont(new Font("Arial", 0, 16));
            publicationPanel.add((Component)publicationLink, new GridBagConstraints(0, 2 * i + 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 0), 0, 0));
        }
        ldaSubtextPanel.add((Component)publicationPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        logoPanel.add((Component)ldaSubtextPanel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 50, 0, 0), 0, 0));
        logoPanel.add((Component)new JLabel(this.ugLogo_), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 50, 0, 0), 0, 0));
        JPanel hartlerLabPanel = new JPanel(new GridBagLayout());
        JHyperlink hartlerLabLink = new JHyperlink("Hartler Lab", "https://pharmazie.uni-graz.at/en/research/pharmaceutical-chemistry/computational-pharmacology");
        hartlerLabLink.setFont(new Font("Arial", 1, 16));
        hartlerLabPanel.add((Component)hartlerLabLink, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 25, 0, 0), 0, 0));
        JLabel uniGrazLabel = new JLabel("University of Graz");
        uniGrazLabel.setFont(new Font("Arial", 0, 16));
        hartlerLabPanel.add((Component)uniGrazLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        logoPanel.add((Component)hartlerLabPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        logoPanel.add((Component)new JLabel(this.tugLogo_), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 50, 0, 0), 0, 0));
        JPanel thallingerLabPanel = new JPanel(new GridBagLayout());
        JHyperlink thallingerLabLink = new JHyperlink("Thallinger Lab", "http://genome.tugraz.at/lda2");
        thallingerLabLink.setFont(new Font("Arial", 1, 16));
        thallingerLabPanel.add((Component)thallingerLabLink, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 25, 0, 0), 0, 0));
        JLabel tugLabel = new JLabel("Graz University of Technology");
        tugLabel.setFont(new Font("Arial", 0, 16));
        thallingerLabPanel.add((Component)tugLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        logoPanel.add((Component)thallingerLabPanel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new GridBagLayout());
        logoPanel.add((Component)headerPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 20, 0), 0, 0));
        this.addFooterLabel(logoPanel, "Copyright \u00a9 2025 J\u00fcrgen Hartler, Andreas Ziegl, Gerhard G Thallinger, Leonida M Lamp", "Arial", 0, 12, 0, 7, 3);
        String[] licenseTexts = new String[]{"This program is free software: you may redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation,", "either version 3 of the License, or (at your option) any later version. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;", "without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.", "You should have received a copy of the GNU General Public License along with this program. If not, see: "};
        for (int i = 0; i < licenseTexts.length; ++i) {
            this.addFooterLabel(logoPanel, licenseTexts[i], "Arial", 0, 10, 0, 8 + i, 2);
        }
        JHyperlink gnuLinkText = new JHyperlink("gnu.org/licenses/", "http://www.gnu.org/licenses/");
        gnuLinkText.setFont(new Font("Arial", 0, 12));
        logoPanel.add((Component)gnuLinkText, new GridBagConstraints(0, 18, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 50, 20, 0), 0, 0));
        if (Settings.isWindows()) {
            String[] windowsTexts = new String[]{"For msconvert file translation (ProteoWizard), the following third-party software is provided:", "WIFF Reader Distributable Beta SDK. Copyright \u00a9 2013 AB SCIEX", "MASSHUNTER DATA ACCESS COMPONENT RUNTIME VERSION. Copyright \u00a9 2016 Agilent Technologies", "This software uses CompassXtract software. Copyright \u00a9 2011, 2013, 2013 by Bruker Daltonik GmbH. All rights reserved.", "MSFileReader file reading tool. Copyright \u00a9 2009 - 2014 by Thermo Fisher Scientific, Inc. All rights reserved.", "These are individual software packages which in no event represent combined work with Lipid Data Analyzer.", "None of these software are governed by the license the Lipid Data Analyzer (GNU GPL) is providing you."};
            for (int i = 0; i < windowsTexts.length; ++i) {
                this.addFooterLabel(logoPanel, windowsTexts[i], "Arial", 0, 10, 0, 19 + i, 2);
            }
        }
    }

    private void addHeaderLabel(JPanel panel, String text, String fontName, int fontStyle, int fontSize, int x, int y) {
        JLabel label = new JLabel(text);
        label.setFont(new Font(fontName, fontStyle, fontSize));
        panel.add((Component)label, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addFooterLabel(JPanel panel, String text, String fontName, int fontStyle, int fontSize, int x, int y, int gridWidth) {
        JLabel label = new JLabel(text);
        label.setFont(new Font(fontName, fontStyle, fontSize));
        panel.add((Component)label, new GridBagConstraints(x, y, gridWidth, 1, 0.0, 0.0, 17, 0, new Insets(0, 50, 0, 0), 0, 0));
    }
}

